%     NITOOL     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO EVOLVE SYSTEMS USING NATURE INSPIRED TOOLBOX [NIT]
% ======================================================
%   USAGE :
%         1. nitool('file.PSO')
%         2. nitool(struct)
%         3. nitool
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function nitool(action)
selectColor = [1 0.3 0.3];

if nargin < 1
    newNIT = newnit('Untitled', 'PSO');
    action=newNIT;
    nipanel = 'None';
end


if isstr(action),
    if action(1) ~= '#'
        ['Disk File Input: ' action];
        nit = rdnit(action);
        nipanel = nit.Type;
        action = '#initialize';
    end
else
    nit = action;
    if isfield(nit, 'Type')
        nipanel = nit.Type;
    end
    ['WS Structure Input: ' nit.Name];
    action = '#initialize';
end

if strcmp(action,'#initialize'),
    % Detect any NIT Editors out there with exactly the same name
    nitName=nit.Name;
    figName=['NIT Editor: ' nitName];
    while findall(0, 'Type', 'figure', 'Name', figName),
        nameLen=length(nitName);
        lastChar=nitName(nameLen);
        if abs(lastChar)>47 & abs(lastChar)<58,
            nitName(nameLen)=lastChar+1;
        else
            nitName=[nitName '2'];
        end
        nit.Name=nitName;
        figName=['NIT Editor: ' nitName];
    end

    %===================================
    % Information for all objects
    frmColor = 192/255*[1 1 1];
    BtnColor = 192/255*[1 1 1];
    popupColor = 192/255*[1 1 1];
    EdtColor = 255/255*[1 1 1];
    BkColor = [0.9 0.9 0.9];
    HBColor = [0.5 0.5 0.5];
    HTColor = [1 1 0];
    PColor = [0 0 1];
    border = 6;
    spacing = 6;
    figPos = [150 200 500 450];
    maxRight = figPos(3);
    maxTop = figPos(4);
    btnWid = 110;
    btnHt = 23;

    %====================================
    % The NIT FIGURE
    thisnit{1}=nit;
    figNit=figure( ...
        'Name', figName, ...
        'NumberTitle', 'off', ...
        'Color', BkColor, ...
        'CloseRequestFcn', 'nitgui #fileclose',...
        'IntegerHandle', 'off',...
        'Visible', 'on', ...
        'MenuBar', 'none', ...
        'UserData', thisnit, ...
        'Units', 'pixels', ...
        'DefaultAxesXColor', 'black', ...
        'DefaultAxesYColor', 'black', ...
        'Position', figPos, ...
        'Tag', 'nitFig', ...
        'ButtonDownFcn', '', ...
        'KeyPressFcn', '', ...
        'DockControls', 'off');
    % The PLOT FIGURE    
    figPlot = figure( ...
        'Name', ['NIT Plots: ' nit.Name], ...
        'NumberTitle', 'off', ...
        'Color', [0.9 0.9 0.9], ...
        'CloseRequestFcn', 'delete(gcf)',...
        'IntegerHandle', 'off',...
        'Visible', 'on', ...
        'MenuBar', 'none', ...
        'UserData', thisnit, ...
        'Units', 'pixels', ...
        'DefaultAxesXColor', 'black', ...
        'DefaultAxesYColor', 'black', ...
        'Position', [665 200 400 473], ...
        'Tag', 'nitPlot', ...
        'ButtonDownFcn', '', ...
        'KeyPressFcn', '', ...
        'DockControls', 'off');
    Gph = axes('Units', 'Normalized',...
        'FontSize', 8,...
        'FontName', 'Verdana',...
        'Position', [0.12 0.1 0.8 0.8],...
        'Box', 'On',...
        'Tag', 'NIGraph',...
        'XGrid', 'On',...
        'YGrid', 'On');
    Xl = xlabel('Iterations',...
        'FontName', 'Verdana',...
        'FontSize', 10);
    Yl = ylabel('Fitness',...
        'FontName', 'Verdana',...
        'FontSize', 10);
    Ttl = title('PROGRESS GRAPHS',...
        'FontName', 'Verdana',...
        'FontSize', 10,...
        'FontWeight', 'Bold');

    % Get Menu Bar
    nitgui #initialize

    %     --------------------------------------------------
    uicontrol(figNit , 'Style', 'PushButton',...
        'Units', 'Normalized',...
        'Position', [0.4 0.02 0.15 0.05],...
        'Callback', 'nitgui #run',...
        'String', 'Run');
    uicontrol(figNit , 'Style', 'PushButton',...
        'Units', 'Normalized',...
        'Position', [0.6 0.02 0.15 0.05],...
        'Callback', 'clc',...
        'String', 'CLC');
    uicontrol(figNit , 'Style', 'PushButton',...
        'Units', 'Normalized',...
        'Position', [0.8 0.02 0.15 0.05],...
        'Callback', 'nitgui #fileclose',...
        'String', 'Close');

    %     --------------------------------------------------
    niX = 0.01; niY = 0.09; niW = 0.98; niH = 0.9;

    PSOpanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH],...
        'BorderType', 'Beveledout',...
        'Visible', 'Off',...
        'Tag', 'PSOpanel',...
        'BackGroundColor', BkColor);
    GApanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH],...
        'BorderType', 'Beveledout',...
        'Visible', 'Off',...
        'BackGroundColor', BkColor);
    ACOpanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH],...
        'BorderType', 'Beveledout',...
        'Visible', 'Off',...
        'BackGroundColor', BkColor);
    BBOpanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH],...
        'BorderType', 'Beveledout',...
        'Visible', 'Off',...
        'BackGroundColor', BkColor);
    Blkpanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH],...
        'BorderType', 'Beveledout',...
        'Visible', 'Off',...
        'BackGroundColor', BkColor);

    switch upper(nipanel)
        case 'PSO'
            set(PSOpanel, 'Visible', 'On');
            set(GApanel, 'Visible', 'Off');
            set(ACOpanel, 'Visible', 'Off');
            set(BBOpanel, 'Visible', 'Off');
        case 'GA'
            set(PSOpanel, 'Visible', 'Off');
            set(GApanel, 'Visible', 'On');
            set(ACOpanel, 'Visible', 'Off');
            set(BBOpanel, 'Visible', 'Off');
        case 'ACO'
            set(PSOpanel, 'Visible', 'Off');
            set(GApanel, 'Visible', 'Off');
            set(ACOpanel, 'Visible', 'On');
            set(BBOpanel, 'Visible', 'Off');
        case 'BBO'
            set(PSOpanel, 'Visible', 'Off');
            set(GApanel, 'Visible', 'Off');
            set(ACOpanel, 'Visible', 'Off');
            set(BBOpanel, 'Visible', 'On');
        otherwise
            set(PSOpanel, 'Visible', 'Off');
            set(GApanel, 'Visible', 'Off');
            set(ACOpanel, 'Visible', 'Off');
            set(BBOpanel, 'Visible', 'Off');
    end

    Hed = 0.03;

    encX = 0.03;    encY = 0.66;    encW = 0.45;    encH = 0.2;
    swmX = 0.03;  swmY = 0.31;  swmW = 0.45;  swmH = 0.29;
    objX = 0.03;     objY = 0.05;    objW = 0.45;     objH = 0.2;

    prmX = 0.52;   prmY = 0.48;   prmW = 0.45;    prmH = 0.45;
    trmX = 0.52;    trmY = 0.26;    trmW = 0.45;    trmH = 0.16;
    pltX = 0.52;      pltY = 0.05;     pltW = 0.45;      pltH = 0.15;
    %     --------------------------------------------------
    %     PARTICLE STRING ENCODING PANEL
    uicontrol(PSOpanel, 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [encX encY+encH encW Hed],...
        'String', 'PARTICLE STRING ENCODING',...
        'HorizontalAlignment', 'Left',...
        'FontName', 'Verdana',...
        'FontWeight', 'Bold',...
        'ForeGroundColor', HTColor,...
        'BackGroundColor', HBColor);
    uicontrol(PSOpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [0.03 0.9 0.45 0.06],...
        'String', 'PSO MODULE',...
        'FontName', 'Agency FB',...
        'FontWeight', 'Bold',...
        'ForeGroundColor', PColor,...
        'FontSize', 18,...
        'BackGroundColor', BkColor);
    
    strpanel = uipanel('Parent', PSOpanel,...
        'Position', [encX encY encW encH],...
        'BorderType', 'Beveledin',...
        'BackGroundColor', BkColor);

    Xt = 0.02; Wt = 0.96; Ht = 0.15;

    uicontrol(strpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 0.8 Wt Ht],...
        'HorizontalAlignment', 'Left',...
        'String', 'Particle String (xls file)',...
        'BackGroundColor', BkColor);
    Xe = 0.02; Ye = 0.5; We = 0.3; Xd = 0.03; He = 0.25;
    uicontrol(strpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+0*(Xd+We) Ye We He],...
        'Tag', 'StringFile',...
        'CallBack', 'nitgui #strfile',...
        'String', 'Encoding.xls',...
        'BackGroundColor', EdtColor);
    uicontrol(strpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+1*(Xd+We) Ye We He],...
        'Tag', 'StringSheet',...
        'CallBack', 'nitgui #strsheet',...
        'String', 'Particle',...
        'BackGroundColor', EdtColor);
    uicontrol(strpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+2*(Xd+We) Ye We He],...
        'Tag', 'StringRange',...
        'CallBack', 'nitgui #strrange',...
        'String', 'B2:D91',...
        'BackGroundColor', EdtColor);

    uicontrol(strpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 0.33 Wt Ht],...
        'HorizontalAlignment', 'Left',...
        'String', 'String Constraints (xls file)',...
        'BackGroundColor', BkColor);
    Xe = 0.02; Ye = 0.05; We = 0.3; Xd = 0.03; He = 0.25;
    uicontrol(strpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+0*(Xd+We) Ye We He],...
        'Tag', 'CheckFile',...
        'CallBack', 'nitgui #chkfile',...
        'String', 'Encoding.xls',...
        'BackGroundColor', EdtColor);
    uicontrol(strpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+1*(Xd+We) Ye We He],...
        'Tag', 'CheckSheet',...
        'CallBack', 'nitgui #chksheet',...
        'String', 'Checks',...
        'BackGroundColor', EdtColor);
    uicontrol(strpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+2*(Xd+We) Ye We He],...
        'Tag', 'CheckRange',...
        'CallBack', 'nitgui #chkrange',...
        'String', 'A2:C21',...
        'BackGroundColor', EdtColor);

    %     --------------------------------------------------
    %     SWARM PANEL
    uicontrol(PSOpanel, 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [swmX swmY+swmH swmW Hed],...
        'String', 'SWARM DESCRIPTION',...
        'HorizontalAlignment', 'Left',...
        'FontName', 'Verdana',...
        'FontWeight', 'Bold',...
        'ForeGroundColor', HTColor,...
        'BackGroundColor', HBColor);
    swmpanel = uipanel('Parent', PSOpanel,...
        'Position', [swmX swmY swmW swmH],...
        'BorderType', 'Beveledin',...
        'BackGroundColor', BkColor);

    Xt = 0.02; Wt = 0.71; H = 0.15;
    Xe = 0.63; We = 0.35; Yd = 0.075;
    uicontrol(swmpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 3*H+4*Yd Wt H],...
        'String', 'Population Size',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(swmpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 3*H+4*Yd We H],...
        'Tag', 'PSize',...
        'String', '20',...
        'CallBack', 'nitgui #psize',...
        'BackGroundColor', EdtColor);
    uicontrol(swmpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 2*H+3*Yd Wt H],...
        'String', 'PSO Model',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(swmpanel , 'Style', 'PopupMenu',...
        'Units', 'Normalized',...
        'Position', [Xe 2*H+3*Yd We H],...
        'Tag', 'PSOModel',...
        'CallBack', 'nitgui #psomodel',...
        'String', ['GBest';'LBest'],...
        'BackGroundColor', EdtColor);
    uicontrol(swmpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 1*H+2*Yd Wt H],...
        'String', 'Neighhood Size',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(swmpanel , 'Style', 'PopupMenu',...
        'Units', 'Normalized',...
        'Position', [Xe 1*H+2*Yd We H],...
        'Tag', 'NSize',...
        'CallBack', 'nitgui #nsize',...
        'String', ['1'; '2'; '3'],...
        'BackGroundColor', EdtColor);
    uicontrol(swmpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 0*H+1*Yd Wt H],...
        'String', 'Topology',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(swmpanel , 'Style', 'PopupMenu',...
        'Units', 'Normalized',...
        'Position', [Xe 0*H+1*Yd We H],...
        'CallBack', 'nitgui #topology',...
        'Tag', 'Topo',...
        'String', strvcat('Ring', 'Linear', 'Wheel'),...
        'BackGroundColor', EdtColor);


    %     --------------------------------------------------
    %     OBJECTIVE PANEL
    uicontrol(PSOpanel, 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [objX objY+objH objW Hed],...
        'String', 'OBJECTIVE DESCRIPTION',...
        'HorizontalAlignment', 'Left',...
        'FontName', 'Verdana',...
        'FontWeight', 'Bold',...
        'ForeGroundColor', HTColor,...
        'BackGroundColor', HBColor);
    objpanel = uipanel('Parent', PSOpanel,...
        'Position', [objX objY objW objH],...
        'BorderType', 'Beveledin',...
        'BackGroundColor', BkColor);

    Xt = 0.02; Wt = 0.96; Ht = 0.15; He = 0.14;

    uicontrol(objpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 0.8 Wt Ht],...
        'HorizontalAlignment', 'Left',...
        'String', 'Training Data (xls file)',...
        'BackGroundColor', BkColor);
    Xe = 0.02; Ye = 0.5; We = 0.3; Xd = 0.03; He = 0.25;
    uicontrol(objpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+0*(Xd+We) Ye We He],...
        'Tag', 'TrgFile',...
        'CallBack', 'nitgui #trgfile',...
        'String', 'Training.xls',...
        'BackGroundColor', EdtColor);
    uicontrol(objpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+1*(Xd+We) Ye We He],...
        'Tag', 'TrgSheet',...
        'CallBack', 'nitgui #trgsheet',...
        'String', 'Data',...
        'BackGroundColor', EdtColor);
    uicontrol(objpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe+2*(Xd+We) Ye We He],...
        'Tag', 'TrgRange',...
        'CallBack', 'nitgui #trgrange',...
        'String', 'A1:E501',...
        'BackGroundColor', EdtColor);

    uicontrol(objpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 0.15 0.6 Ht],...
        'HorizontalAlignment', 'Left',...
        'String', 'Objective Function',...
        'BackGroundColor', BkColor);
    uicontrol(objpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xt+0.46 0.1 0.5 He],...
        'String', 'myObject',...
        'CallBack', 'nitgui #FitFun',...
        'Tag', 'FitnessFn',...
        'BackGroundColor', EdtColor);

    %     --------------------------------------------------
    %     PARAMETER PANEL
    uicontrol(PSOpanel, 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [prmX prmY+prmH prmW Hed],...
        'String', 'STRATEGIC PARAMETERS',...
        'HorizontalAlignment', 'Left',...
        'FontName', 'Verdana',...
        'FontWeight', 'Bold',...
        'ForeGroundColor', HTColor,...
        'BackGroundColor', HBColor);
    parapanel = uipanel('Parent', PSOpanel,...
        'Position', [prmX prmY prmW prmH],...
        'BorderType', 'Beveledin',...
        'BackGroundColor', BkColor);

    Xt = 0.02; Wt = 0.76; H = 0.106;
    Xe = 0.68; We = 0.3; Yd = 0.015;
    uicontrol(parapanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 7*H+8*Yd Wt H],...
        'String', 'Cognitive Acceleration (C1)',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(parapanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 7*H+8*Yd We H],...
        'Tag','ParC1',...
        'CallBack', 'nitgui #C1',...
        'String', '0.1',...
        'BackGroundColor', EdtColor);
    uicontrol(parapanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 6*H+7*Yd Wt H],...
        'String', 'Social Acceleration (C2)',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(parapanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 6*H+7*Yd We H],...
        'Tag','ParC2',...
        'CallBack', 'nitgui #C2',...
        'String', '0.2',...
        'BackGroundColor', EdtColor);
    uicontrol(parapanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 5*H+6*Yd Wt H],...
        'String', 'Neighbour Acceleration (C3)',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(parapanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 5*H+6*Yd We H],...
        'Tag','ParC3',...
        'CallBack', 'nitgui #C3',...
        'String', '0.3',...
        'BackGroundColor', EdtColor);
    uicontrol(parapanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 4*H+5*Yd Wt H],...
        'String', 'Maximum Velocity (Vel)',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(parapanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 4*H+5*Yd We H],...
        'Tag','MxVel',...
        'CallBack', 'nitgui #velo',...
        'String', '0.5',...
        'BackGroundColor', EdtColor);
    uicontrol(parapanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 3*H+4*Yd Wt H],...
        'String', 'Constriction Factor (Chi)',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(parapanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 3*H+4*Yd We H],...
        'Tag','Limt',...
        'CallBack', 'nitgui #chi',...
        'String', '1',...
        'BackGroundColor', EdtColor);
    uicontrol(parapanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 2*H+3*Yd Wt H],...
        'String', 'Weight Variation (Wv)',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(parapanel , 'Style', 'PopupMenu',...
        'Units', 'Normalized',...
        'Position', [Xe 2*H+3*Yd We H],...
        'Tag','WtOpt',...
        'CallBack', 'nitgui #WtOption',...
        'String', ['Fixed   ';'Variable'],...
        'BackGroundColor', EdtColor);
    uicontrol(parapanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 1*H+2*Yd Wt H],...
        'String', 'Start Inertia Weight (Ws)',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(parapanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 1*H+2*Yd We H],...
        'Tag','StWt',...
        'CallBack', 'nitgui #startwt',...
        'String', '1',...
        'BackGroundColor', EdtColor);
    uicontrol(parapanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 0*H+1*Yd Wt H],...
        'String', 'End Inertia Weight (We)',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(parapanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 0*H+1*Yd We H],...
        'Tag','NdWt',...
        'CallBack', 'nitgui #endwt',...
        'String', '0',...
        'Enable', 'Off',...
        'BackGroundColor', EdtColor);


    %     --------------------------------------------------
    %     TERMINATION CRITERIA PANEL
    uicontrol(PSOpanel, 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [trmX trmY+trmH trmW Hed],...
        'String', 'TERMINATION CRITERIA',...
        'HorizontalAlignment', 'Left',...
        'FontName', 'Verdana',...
        'FontWeight', 'Bold',...
        'ForeGroundColor', HTColor,...
        'BackGroundColor', HBColor);
    trmpanel = uipanel('Parent', PSOpanel,...
        'Position', [trmX trmY trmW trmH],...
        'BorderType', 'Beveledin',...
        'BackGroundColor', BkColor);

    Xt = 0.02; Wt = 0.76; H = 0.22;
    Xe = 0.78; We = 0.2; Yd = 0.075;
    uicontrol(trmpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 2*H+3*Yd Wt H],...
        'String', 'Same-Fitness Iterations',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(trmpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 2*H+3*Yd We H],...
        'Tag', 'SameFitness',...
        'CallBack', 'nitgui #nochange',...
        'String', '10',...
        'BackGroundColor', EdtColor);
    uicontrol(trmpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 1*H+2*Yd Wt H],...
        'String', 'Objective Value',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(trmpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 1*H+2*Yd We H],...
        'Tag', 'ObjVal',...
        'CallBack', 'nitgui #objval',...
        'String', '1e-10',...
        'BackGroundColor', EdtColor);
    uicontrol(trmpanel , 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [Xt 0*H+1*Yd Wt H],...
        'String', 'Number of Iterations',...
        'HorizontalAlignment', 'Left',...
        'BackGroundColor', BkColor);
    uicontrol(trmpanel , 'Style', 'Edit',...
        'Units', 'Normalized',...
        'Position', [Xe 0*H+1*Yd We H],...
        'Tag', 'Iterations',...
        'CallBack', 'nitgui #maxitr',...
        'String', '1000',...
        'BackGroundColor', EdtColor);


    %     --------------------------------------------------
    %     PLOT PANEL
    uicontrol(PSOpanel, 'Style', 'Text',...
        'Units', 'Normalized',...
        'Position', [pltX pltY+pltH pltW Hed],...
        'String', 'PLOT OPTIONS',...
        'HorizontalAlignment', 'Left',...
        'FontName', 'Verdana',...
        'FontWeight', 'Bold',...
        'ForeGroundColor', HTColor,...
        'BackGroundColor', HBColor);
    plotpanel = uipanel('Parent', PSOpanel,...
        'Position', [pltX pltY pltW pltH],...
        'BorderType', 'Beveledin',...
        'BackGroundColor', BkColor);

    Xt = 0.03; Wc = 0.96; H = 0.2; Yd = 0.1;
    uicontrol(plotpanel , 'Style', 'CheckBox',...
        'Units', 'Normalized',...
        'Position', [Xt 2*H+3*Yd Wc H],...
        'Tag', 'plotGBest',...
        'String', 'Global Best Fitness',...
        'Value', 1,...
        'CallBack', 'nitgui #nitplots', ...
        'BackGroundColor', BkColor);
    uicontrol(plotpanel , 'Style', 'CheckBox',...
        'Units', 'Normalized',...
        'Position', [Xt 1*H+2*Yd Wc H],...
        'Tag', 'plotAvg',...
        'String', 'Average Best Fitness',...
        'Value', 1,...
        'CallBack', 'nitgui #nitplots', ...
        'BackGroundColor', BkColor);
    uicontrol(plotpanel , 'Style', 'CheckBox',...
        'Units', 'Normalized',...
        'Position', [Xt 0*H+1*Yd Wc H],...
        'Tag', 'plotLBest',...
        'String', 'Local Best Fitnesses',...
        'Enable', 'Off',...
        'Value', 0,...
        'CallBack', 'nitgui #nitplots', ...
        'BackGroundColor', BkColor);

    nitool #update

elseif strcmp(action,'#update'),
    %====================================
    fig = watchon;
    oldnit = get(fig,'UserData');
    nit = oldnit{1};
    figNit = findobj(0, 'Type', 'Figure', 'Name', ['NIT Editor: ' nit.Name]);

    set(figNit, 'Name', ['NIT Editor: ' nit.Name]);
    Hdl = findobj(figNit, 'Tag', 'StringFile');
    set(Hdl, 'String', nit.String.File);
    watchoff(figNit);
    Hdl = findobj(figNit, 'Tag', 'StringSheet');
    set(Hdl, 'String', nit.String.Sheet);
    watchoff(figNit);
    Hdl = findobj(figNit, 'Tag', 'StringRange');
    set(Hdl, 'String', nit.String.Range);

    Hdl = findobj(figNit, 'Tag', 'CheckFile');
    set(Hdl, 'String', nit.Checks.File);
    watchoff(figNit);
    Hdl = findobj(figNit, 'Tag', 'CheckSheet');
    set(Hdl, 'String', nit.Checks.Sheet);
    watchoff(figNit);
    Hdl = findobj(figNit, 'Tag', 'CheckRange');
    set(Hdl, 'String', nit.Checks.Range);

    Hdl = findobj(figNit, 'Tag', 'PSize');
    set(Hdl, 'String', nit.Swarm.PSize);
    if nit.Swarm.Model=='GBest'
        Hdl = findobj(figNit, 'Tag', 'PSOModel');
        set(Hdl, 'Value', 1);
        Hdl = findobj(figNit, 'Tag', 'NSize');
        set(Hdl, 'Enable', 'Off');
        Hdl = findobj(figNit, 'Tag', 'Topo');
        set(Hdl, 'Enable', 'Off');
        LHdl = findobj(figNit, 'Tag', 'plotLBest');
        set(LHdl, 'Value', nit.Plot.LBest, 'Enable', 'Off');
    elseif nit.Swarm.Model=='LBest'
        Hdl = findobj(figNit, 'Tag', 'PSOModel');
        set(Hdl, 'Value', 2);
        Hdl = findobj(figNit, 'Tag', 'NSize');
        set(Hdl, 'Value', nit.Swarm.NSize, 'Enable', 'On');
        Hdl = findobj(figNit, 'Tag', 'Topo');
        TopStr = get(Hdl, 'String');
        Val = strmatch(strtok(nit.Swarm.Topology), TopStr, 'Exac');
        set(Hdl, 'Value', Val, 'Enable', 'On');
        LHdl = findobj(figNit, 'Tag', 'plotLBest');
        set(LHdl, 'Value', nit.Plot.LBest, 'Enable', 'On');
    end

    Hdl = findobj(figNit, 'Tag', 'TrgFile');
    set(Hdl, 'String', nit.Objective.File);
    watchoff(figNit);
    Hdl = findobj(figNit, 'Tag', 'TrgSheet');
    set(Hdl, 'String', nit.Objective.Sheet);
    watchoff(figNit);
    Hdl = findobj(figNit, 'Tag', 'TrgRange');
    set(Hdl, 'String', nit.Objective.Range);
    Hdl = findobj(figNit, 'Tag', 'FitnessFn');
    set(Hdl, 'String', nit.Objective.Function);

    Hdl = findobj(figNit, 'Tag', 'ParC1');
    set(Hdl, 'String', nit.Parameter.C1);
    Hdl = findobj(figNit, 'Tag', 'ParC2');
    set(Hdl, 'String', nit.Parameter.C2);
    Hdl = findobj(figNit, 'Tag', 'ParC3');
    set(Hdl, 'String', nit.Parameter.C3);
    Hdl = findobj(figNit, 'Tag', 'MxVel');
    set(Hdl, 'String', nit.Parameter.MaxVelocity);
    Hdl = findobj(figNit, 'Tag', 'Limt');
    set(Hdl, 'String', nit.Parameter.Chi);
    Hdl = findobj(figNit, 'Tag', 'StWt');
    set(Hdl, 'String', nit.Parameter.StartWeight);
    if strcmp(nit.Parameter.WeightOption, 'Fixed')
        Hdl = findobj(figNit, 'Tag', 'WtOpt');
        set(Hdl, 'Value', 1);
        Hdl = findobj(figNit, 'Tag', 'NdWt');
        set(Hdl, 'Enable', 'Off');
    elseif strcmp(nit.Parameter.WeightOption, 'Variable')
        Hdl = findobj(figNit, 'Tag', 'WtOpt');
        set(Hdl, 'Value', 2);
        Hdl = findobj(figNit, 'Tag', 'NdWt');
        set(Hdl, 'String', nit.Parameter.EndWeight, 'Enable', 'On');
    end

    Hdl = findobj(figNit, 'Tag', 'SameFitness');
    set(Hdl, 'String', nit.Terminate.NoChange);
    Hdl = findobj(figNit, 'Tag', 'ObjVal');
    set(Hdl, 'String', nit.Terminate.Goal);
    Hdl = findobj(figNit, 'Tag', 'Iterations');
    set(Hdl, 'String', nit.Terminate.MaxIterations);

    GHdl = findobj(figNit, 'Tag', 'plotGBest');
    set(GHdl, 'Value', nit.Plot.GBest);
    PHdl = findobj(figNit, 'Tag', 'plotAvg');
    set(PHdl, 'Value', nit.Plot.Average);

    Val = [nit.Plot.GBest nit.Plot.Average nit.Plot.LBest];
    
    figPlot = findobj(0, 'Type', 'Figure', 'Name', 'NIT Plots', 'Tag', 'nitPlot');
    if sum(Val) ~= 0
        set(figPlot, 'Visible', 'On');
    else
        set(figPlot, 'Visible', 'Off');
    end
    
    set(figNit, 'UserData', nit, 'Visible', 'On');
    watchoff(figNit);
end